/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.network.server.move;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import net.minecraft.network.FriendlyByteBuf;
import net.sixik.sdmshoprework.SDMShopRework;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.utils.ListHelper;
import net.sixik.sdmshoprework.network.ShopNetwork;
import net.sixik.sdmshoprework.network.client.SyncShopS2C;

public class SendMoveShopTabC2S
extends BaseC2SMessage {
    private final int from;
    private final int to;

    public SendMoveShopTabC2S(int from, int to) {
        this.from = from;
        this.to = to;
    }

    public SendMoveShopTabC2S(FriendlyByteBuf buf) {
        this.from = buf.readInt();
        this.to = buf.readInt();
    }

    public MessageType getType() {
        return ShopNetwork.SEND_MOVE_TAB;
    }

    public void write(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeInt(this.from);
        friendlyByteBuf.writeInt(this.to);
    }

    public void handle(NetworkManager.PacketContext packetContext) {
        try {
            ListHelper.swap(ShopBase.SERVER.getShopTabs(), this.from, this.to);
            new SyncShopS2C(ShopBase.SERVER.serializeNBT()).sendToAll(packetContext.getPlayer().m_20194_());
            ShopBase.SERVER.saveShopToFile();
        }
        catch (Exception e) {
            SDMShopRework.printStackTrace("", e);
        }
    }
}

